//Gemma-7B DATASET v1.0 Category: Space Invaders Game Clone ; Style: systematic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define LEFT_BOUND 0
#define RIGHT_BOUND 5
#define TOP_BOUND 0
#define BOTTOM_BOUND 2

int main()
{
    int x, y, score = 0, direction = 1;
    char board[3][6] = {{'.', '.', '.', '.', '.', '.'},
                              {'.', ' ', ' ', ' ', ' ', '.'},
                              {'.', '.', '.', '.', '.', '.'}};

    // Seed the random number generator
    srand(time(NULL));

    // Initialize the invader's position
    x = rand() % (RIGHT_BOUND - LEFT_BOUND + 1) + LEFT_BOUND;
    y = TOP_BOUND;

    // Game loop
    while (!board[y][x] && score < 10)
    {
        // Display the board
        for (int i = 0; i < 3; i++)
        {
            for (int j = 0; j < 6; j++)
            {
                printf("%c ", board[i][j]);
            }
            printf("\n");
        }

        // Move the invader
        switch (direction)
        {
            case 1:
                x++;
                break;
            case 2:
                x--;
                break;
            case 3:
                y++;
                break;
            case 4:
                y--;
                break;
        }

        // Check if the invader has reached the edge of the board
        if (x < LEFT_BOUND || x > RIGHT_BOUND)
        {
            direction *= -1;
        }

        // Check if the invader has reached the bottom of the board
        if (y > BOTTOM_BOUND)
        {
            printf("Game Over! Your score is: %d", score);
            break;
        }

        // Update the board
        board[y][x] = 'I';

        // Increment the score
        score++;
    }

    return 0;
}