//Falcon-180B DATASET v1.0 Category: Packet Capturer with pcap library ; Style: ephemeral
#include <stdio.h>
#include <stdlib.h>
#include <pcap.h>
#include <string.h>
#include <arpa/inet.h>

#define MAX_PACKET_SIZE 65535

typedef struct {
    u_char *packet_data;
    int packet_size;
    struct pcap_pkthdr header;
} Packet;

void packet_handler(u_char *user, const struct pcap_pkthdr *header, const u_char *packet) {
    Packet *packet_info = (Packet *)user;
    packet_info->header = *header;
    packet_info->packet_data = (u_char *)malloc(header->caplen);
    packet_info->packet_size = header->caplen;
    memcpy(packet_info->packet_data, packet, header->caplen);
}

int main() {
    char errbuf[PCAP_ERRBUF_SIZE];
    char *dev = "eth0";
    pcap_t *handle;
    pcap_dumper_t *dump_handle;
    Packet packet;

    handle = pcap_open_live(dev, BUFSIZ, 1, 1000, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Error opening device: %s\n", errbuf);
        exit(1);
    }

    packet.packet_data = NULL;
    packet.packet_size = 0;

    dump_handle = pcap_dump_open(handle, "output.pcap");
    if (dump_handle == NULL) {
        fprintf(stderr, "Error opening output file: %s\n", pcap_geterr(handle));
        exit(1);
    }

    pcap_loop(handle, -1, packet_handler, (u_char *)&packet);

    pcap_dump_close(dump_handle);
    pcap_close(handle);

    return 0;
}