//Gemma-7B DATASET v1.0 Category: Network Ping Test ; Style: configurable
#include <stdio.h>
#include <netdb.h>
#include <sys/socket.h>
#include <unistd.h>

#define HOST_NAME "localhost"
#define PORT_NUMBER 5000

int main() {
  int sockfd;
  struct sockaddr_in server_addr;
  char buffer[1024];
  int bytes_sent = 0, bytes_received = 0;
  char message[] = "Hello, world!";

  // Create a socket
  sockfd = socket(AF_INET, SOCK_STREAM, htons(PORT_NUMBER));
  if (sockfd < 0) {
    perror("Error creating socket");
    return -1;
  }

  // Connect to the server
  server_addr.sin_family = AF_INET;
  server_addr.sin_port = htons(PORT_NUMBER);
  server_addr.sin_addr.s_addr = inet_addr(HOST_NAME);
  if (connect(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
    perror("Error connecting to server");
    return -1;
  }

  // Send a message
  bytes_sent = send(sockfd, message, sizeof(message), 0);
  if (bytes_sent < 0) {
    perror("Error sending message");
    return -1;
  }

  // Receive a message
  bytes_received = recv(sockfd, buffer, sizeof(buffer), 0);
  if (bytes_received < 0) {
    perror("Error receiving message");
    return -1;
  }

  // Print the received message
  printf("Received: %s\n", buffer);

  // Close the socket
  close(sockfd);

  return 0;
}