//GEMINI-pro DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: invasive
#include <stdio.h>
#include <stdlib.h>

// Process structure
typedef struct Process {
    int pid;        // Process ID
    int arrival;    // Arrival time
    int burst;     // Burst time
    int priority;  // Priority
    int remaining; // Remaining time
} Process;

// Function to sort processes by arrival time
int compareArrival(const void *a, const void *b) {
    const Process *p1 = (const Process *)a;
    const Process *p2 = (const Process *)b;
    return p1->arrival - p2->arrival;
}

// Function to perform Shortest Job First (SJF) scheduling
int sjf(Process *processes, int n) {
    // Sort processes by arrival time
    qsort(processes, n, sizeof(Process), compareArrival);

    // Initialize variables
    int total_time = 0;
    int waiting_time = 0;

    // Iterate over processes
    for (int i = 0; i < n; i++) {
        // Calculate waiting time
        waiting_time += total_time - processes[i].arrival;

        // Update total time
        total_time += processes[i].burst;
    }

    // Calculate average waiting time
    int avg_waiting_time = waiting_time / n;

    // Return average waiting time
    return avg_waiting_time;
}

// Function to main
int main() {
    // Create an array of processes
    Process processes[] = {
        {1, 0, 5, 1},
        {2, 3, 2, 2},
        {3, 6, 4, 3},
        {4, 9, 1, 4},
        {5, 12, 3, 5}
    };

    // Number of processes
    int n = sizeof(processes) / sizeof(processes[0]);

    // Perform SJF scheduling
    int avg_waiting_time = sjf(processes, n);

    // Print average waiting time
    printf("Average waiting time: %d\n", avg_waiting_time);

    return 0;
}