//Gemma-7B DATASET v1.0 Category: Intrusion detection system ; Style: thoughtful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SENSOR_NUM 10

typedef struct Sensor
{
    int sensor_num;
    char status;
    char timestamp[20];
} Sensor;

Sensor sensors[MAX_SENSOR_NUM];

void init_sensors()
{
    for (int i = 0; i < MAX_SENSOR_NUM; i++)
    {
        sensors[i].sensor_num = i + 1;
        sensors[i].status = 'N';
        sensors[i].timestamp[0] = '\0';
    }
}

void update_sensor_status(int sensor_num, char status)
{
    for (int i = 0; i < MAX_SENSOR_NUM; i++)
    {
        if (sensors[i].sensor_num == sensor_num)
        {
            sensors[i].status = status;
            sprintf(sensors[i].timestamp, "%s", time(NULL));
            break;
        }
    }
}

int main()
{
    init_sensors();

    update_sensor_status(2, 'A');
    update_sensor_status(5, 'C');

    for (int i = 0; i < MAX_SENSOR_NUM; i++)
    {
        printf("Sensor %d: Status: %c, Timestamp: %s\n", sensors[i].sensor_num, sensors[i].status, sensors[i].timestamp);
    }

    return 0;
}