//GEMINI-pro DATASET v1.0 Category: Building a POP3 Client ; Style: synchronous
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>

#define POP3_PORT 110
#define MAX_BUF_SIZE 1024

int main() {
    int sockfd;
    struct sockaddr_in servaddr;
    char buf[MAX_BUF_SIZE];
    int n;

    // Create a socket
    if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
        perror("socket");
        exit(1);
    }

    // Connect to the POP3 server
    memset(&servaddr, 0, sizeof(servaddr));
    servaddr.sin_family = AF_INET;
    servaddr.sin_port = htons(POP3_PORT);
    servaddr.sin_addr.s_addr = inet_addr("127.0.0.1");

    if (connect(sockfd, (struct sockaddr *) &servaddr, sizeof(servaddr)) == -1) {
        perror("connect");
        exit(1);
    }

    // Send the USER command
    memset(buf, 0, sizeof(buf));
    strcpy(buf, "USER username\r\n");
    if (send(sockfd, buf, strlen(buf), 0) == -1) {
        perror("send");
        exit(1);
    }

    // Receive the response from the server
    memset(buf, 0, sizeof(buf));
    if ((n = recv(sockfd, buf, MAX_BUF_SIZE, 0)) == -1) {
        perror("recv");
        exit(1);
    }

    printf("%s", buf);

    // Send the PASS command
    memset(buf, 0, sizeof(buf));
    strcpy(buf, "PASS password\r\n");
    if (send(sockfd, buf, strlen(buf), 0) == -1) {
        perror("send");
        exit(1);
    }

    // Receive the response from the server
    memset(buf, 0, sizeof(buf));
    if ((n = recv(sockfd, buf, MAX_BUF_SIZE, 0)) == -1) {
        perror("recv");
        exit(1);
    }

    printf("%s", buf);

    // Send the LIST command
    memset(buf, 0, sizeof(buf));
    strcpy(buf, "LIST\r\n");
    if (send(sockfd, buf, strlen(buf), 0) == -1) {
        perror("send");
        exit(1);
    }

    // Receive the response from the server
    memset(buf, 0, sizeof(buf));
    if ((n = recv(sockfd, buf, MAX_BUF_SIZE, 0)) == -1) {
        perror("recv");
        exit(1);
    }

    printf("%s", buf);

    // Send the RETR command
    memset(buf, 0, sizeof(buf));
    strcpy(buf, "RETR 1\r\n");
    if (send(sockfd, buf, strlen(buf), 0) == -1) {
        perror("send");
        exit(1);
    }

    // Receive the response from the server
    memset(buf, 0, sizeof(buf));
    if ((n = recv(sockfd, buf, MAX_BUF_SIZE, 0)) == -1) {
        perror("recv");
        exit(1);
    }

    printf("%s", buf);

    // Send the QUIT command
    memset(buf, 0, sizeof(buf));
    strcpy(buf, "QUIT\r\n");
    if (send(sockfd, buf, strlen(buf), 0) == -1) {
        perror("send");
        exit(1);
    }

    // Close the socket
    close(sockfd);

    return 0;
}