//GEMINI-pro DATASET v1.0 Category: Electronic Voting System ; Style: complex
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

// Data structures
typedef struct {
    char name[50];
    int votes;
} Candidate;

typedef struct {
    int id;
    bool voted;
} Voter;

// Global variables
Candidate candidates[10];
int num_candidates;
Voter voters[100];
int num_voters;

// Function declarations
void add_candidate(char *name);
void add_voter(int id);
void vote(int voter_id, int candidate_id);
void print_results();

// Main function
int main() {
    // Initialize data structures
    num_candidates = 0;
    num_voters = 0;

    // Add candidates
    add_candidate("Candidate 1");
    add_candidate("Candidate 2");
    add_candidate("Candidate 3");

    // Add voters
    add_voter(1);
    add_voter(2);
    add_voter(3);

    // Simulate voting
    vote(1, 1);
    vote(2, 2);
    vote(3, 3);

    // Print results
    print_results();

    return 0;
}

// Function definitions
void add_candidate(char *name) {
    strcpy(candidates[num_candidates].name, name);
    candidates[num_candidates].votes = 0;
    num_candidates++;
}

void add_voter(int id) {
    voters[num_voters].id = id;
    voters[num_voters].voted = false;
    num_voters++;
}

void vote(int voter_id, int candidate_id) {
    // Check if voter has already voted
    if (voters[voter_id - 1].voted) {
        printf("Error: Voter has already voted.\n");
        return;
    }

    // Check if candidate is valid
    if (candidate_id < 1 || candidate_id > num_candidates) {
        printf("Error: Invalid candidate ID.\n");
        return;
    }

    // Increment candidate's vote count
    candidates[candidate_id - 1].votes++;

    // Mark voter as having voted
    voters[voter_id - 1].voted = true;
}

void print_results() {
    // Find the winner
    int winning_candidate_id = 0;
    int max_votes = 0;
    for (int i = 0; i < num_candidates; i++) {
        if (candidates[i].votes > max_votes) {
            max_votes = candidates[i].votes;
            winning_candidate_id = i;
        }
    }

    // Print the results
    printf("------------------------\n");
    printf("Voting Results\n");
    printf("------------------------\n");
    for (int i = 0; i < num_candidates; i++) {
        printf("%s: %d votes\n", candidates[i].name, candidates[i].votes);
    }
    printf("------------------------\n");
    printf("Winner: %s\n", candidates[winning_candidate_id].name);
    printf("------------------------\n");
}