//Gemma-7B DATASET v1.0 Category: Medical Store Management System ; Style: funny
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PRODUCTS 10
#define MAX_CUSTOMERS 5

typedef struct Product {
    char name[20];
    int quantity;
    double price;
} Product;

typedef struct Customer {
    char name[20];
    char address[100];
    int phone;
    double total_spent;
} Customer;

Product products[MAX_PRODUCTS] = {
    {"Tylenol", 200, 2.50},
    {"Pepto-Bismol", 150, 3.00},
    {"Ibuprofen", 100, 2.00},
    {"Acetaminophen", 50, 1.50},
    {"Dramamine", 75, 2.25},
    {"Benadryl", 25, 1.75},
    {"Tums", 125, 2.75},
    {"Rolaids", 80, 2.25},
    {"Mylanta", 60, 1.00},
    {"Peptobismol Forte", 20, 3.50}
};

Customer customers[MAX_CUSTOMERS] = {
    {"John Doe", "123 Main St.", 555, 100.00},
    {"Jane Doe", "456 Oak Ave.", 123, 200.00},
    {"Bill Smith", "789 Oak St.", 412, 50.00},
    {"Mary Johnson", "321 Main St.", 841, 150.00},
    {"Bob Brown", "654 Oak Ave.", 248, 225.00}
};

void update_product_quantity(char *name, int quantity) {
    for (int i = 0; i < MAX_PRODUCTS; i++) {
        if (strcmp(products[i].name, name) == 0) {
            products[i].quantity = quantity;
        }
    }
}

void update_customer_total_spent(char *name, double total_spent) {
    for (int i = 0; i < MAX_CUSTOMERS; i++) {
        if (strcmp(customers[i].name, name) == 0) {
            customers[i].total_spent = total_spent;
        }
    }
}

int main() {
    update_product_quantity("Tylenol", 250);
    update_customer_total_spent("John Doe", 250.00);

    for (int i = 0; i < MAX_PRODUCTS; i++) {
        printf("Product: %s, Quantity: %d, Price: %.2lf\n", products[i].name, products[i].quantity, products[i].price);
    }

    for (int i = 0; i < MAX_CUSTOMERS; i++) {
        printf("Customer: %s, Address: %s, Phone: %d, Total Spent: %.2lf\n", customers[i].name, customers[i].address, customers[i].phone, customers[i].total_spent);
    }

    return 0;
}