//GPT-4o-mini DATASET v1.0 Category: Browser Plugin ; Style: single-threaded
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

#define MAX_BUTTON_ID_LENGTH 50

// Function to create the JavaScript that will be injected into the browser.
const char* create_js_plugin() {
    return  "var count = 0;\n"
            "function countClicks() {\n"
            "    count++;\n"
            "    alert('Button clicked ' + count + ' times');\n"
            "}\n"
            "document.addEventListener('DOMContentLoaded', function() {\n"
            "    var button = document.createElement('button');\n"
            "    button.innerHTML = 'Click Me!';\n"
            "    button.id = 'countButton';\n"
            "    button.onclick = countClicks;\n"
            "    document.body.appendChild(button);\n"
            "});\n";
}

// Mocking the browser plugin structure
typedef struct {
    char name[MAX_BUTTON_ID_LENGTH];
    const char* js_code;
} BrowserPlugin;

// Function to set up the plugin
void setup_plugin(BrowserPlugin* plugin) {
    snprintf(plugin->name, sizeof(plugin->name), "Click Counter");
    plugin->js_code = create_js_plugin();
}

// Function to simulate the behavior of loading the plugin
void load_plugin(BrowserPlugin* plugin) {
    printf("Loading Plugin: %s\n", plugin->name);
    printf("Injected JavaScript:\n%s\n", plugin->js_code);
}

// Main function to mimic plugin behavior
int main() {
    BrowserPlugin clickCounter;
    setup_plugin(&clickCounter);
    load_plugin(&clickCounter);
    
    // In a real browser environment, here we would cleanly exit
    // after the plugin is no longer needed.
    printf("Plugin loaded successfully.\n");
    
    return 0;
}