//Gemma-7B DATASET v1.0 Category: Traffic Flow Simulation ; Style: multivariable
#include <stdlib.h>
#include <stdio.h>
#include <time.h>

#define MAX_CARS 10
#define MAX_LANE 3

typedef struct Car {
    int x, y, direction, speed;
} Car;

Car cars[MAX_CARS];

void initialize_cars() {
    for (int i = 0; i < MAX_CARS; i++) {
        cars[i].x = rand() % MAX_LANE;
        cars[i].y = rand() % MAX_LANE;
        cars[i].direction = rand() % 2;
        cars[i].speed = rand() % 5 + 1;
    }
}

void move_cars() {
    for (int i = 0; i < MAX_CARS; i++) {
        switch (cars[i].direction) {
            case 0:
                cars[i].x++;
                break;
            case 1:
                cars[i].x--;
                break;
            case 2:
                cars[i].y++;
                break;
            case 3:
                cars[i].y--;
                break;
        }

        cars[i].x = (cars[i].x < 0) ? MAX_LANE - 1 : (cars[i].x >= MAX_LANE) ? 0 : cars[i].x;
        cars[i].y = (cars[i].y < 0) ? MAX_LANE - 1 : (cars[i].y >= MAX_LANE) ? 0 : cars[i].y;
    }
}

int main() {
    initialize_cars();
    move_cars();

    for (int i = 0; i < MAX_CARS; i++) {
        printf("Car %d: x = %d, y = %d, direction = %d, speed = %d\n", i, cars[i].x, cars[i].y, cars[i].direction, cars[i].speed);
    }

    return 0;
}