//GEMINI-pro DATASET v1.0 Category: Geometric algorithms ; Style: expert-level
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct point {
    double x;
    double y;
} point;

typedef struct line {
    point p1;
    point p2;
} line;

typedef struct circle {
    point center;
    double radius;
} circle;

// Function to check if a point is on a line
int is_on_line(point p, line l) {
    double dx = l.p2.x - l.p1.x;
    double dy = l.p2.y - l.p1.y;
    double t = ((p.x - l.p1.x) * dx + (p.y - l.p1.y) * dy) / (dx * dx + dy * dy);
    return t >= 0 && t <= 1;
}

// Function to check if a point is inside a circle
int is_inside_circle(point p, circle c) {
    double dx = p.x - c.center.x;
    double dy = p.y - c.center.y;
    return dx * dx + dy * dy <= c.radius * c.radius;
}

// Function to check if two lines intersect
int do_lines_intersect(line l1, line l2) {
    double x1 = l1.p1.x;
    double y1 = l1.p1.y;
    double x2 = l1.p2.x;
    double y2 = l1.p2.y;
    double x3 = l2.p1.x;
    double y3 = l2.p1.y;
    double x4 = l2.p2.x;
    double y4 = l2.p2.y;
    double d = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);
    if (d == 0) return 0;
    double t1 = ((x3 - x4) * (y1 - y3) - (y3 - y4) * (x1 - x3)) / d;
    double t2 = ((x1 - x2) * (y1 - y3) - (y1 - y2) * (x1 - x3)) / d;
    return t1 >= 0 && t1 <= 1 && t2 >= 0 && t2 <= 1;
}

// Function to check if two circles intersect
int do_circles_intersect(circle c1, circle c2) {
    double dx = c1.center.x - c2.center.x;
    double dy = c1.center.y - c2.center.y;
    double distance = sqrt(dx * dx + dy * dy);
    return distance <= c1.radius + c2.radius;
}

int main() {
    // Create a point
    point p1 = {1, 2};

    // Create a line
    line l1 = {{0, 0}, {1, 1}};

    // Check if the point is on the line
    int is_on = is_on_line(p1, l1);
    printf("Is the point on the line? %s\n", is_on ? "Yes" : "No");

    // Create a circle
    circle c1 = {{0, 0}, 1};

    // Check if the point is inside the circle
    int is_inside = is_inside_circle(p1, c1);
    printf("Is the point inside the circle? %s\n", is_inside ? "Yes" : "No");

    // Create another line
    line l2 = {{1, 0}, {0, 1}};

    // Check if the two lines intersect
    int do_intersect = do_lines_intersect(l1, l2);
    printf("Do the two lines intersect? %s\n", do_intersect ? "Yes" : "No");

    // Create another circle
    circle c2 = {{1, 1}, 1};

    // Check if the two circles intersect
    do_intersect = do_circles_intersect(c1, c2);
    printf("Do the two circles intersect? %s\n", do_intersect ? "Yes" : "No");

    return 0;
}