//Falcon-180B DATASET v1.0 Category: Product Inventory System ; Style: optimized
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define structure for product inventory
typedef struct {
    char name[50];
    int quantity;
    float price;
} Product;

// Function to add new product to inventory
void addProduct(Product *inventory, int size, char *name, int quantity, float price) {
    for (int i = 0; i < size; i++) {
        if (strcmp(inventory[i].name, name) == 0) {
            inventory[i].quantity += quantity;
            return;
        }
    }
    strcpy(inventory[size].name, name);
    inventory[size].quantity = quantity;
    inventory[size].price = price;
    size++;
}

// Function to update quantity of product in inventory
void updateProduct(Product *inventory, int size, char *name, int quantity) {
    for (int i = 0; i < size; i++) {
        if (strcmp(inventory[i].name, name) == 0) {
            inventory[i].quantity += quantity;
            return;
        }
    }
}

// Function to display inventory
void displayInventory(Product *inventory, int size) {
    printf("Product Inventory:\n");
    printf("-------------------\n");
    printf("Name\t\tQuantity\tPrice\n");
    for (int i = 0; i < size; i++) {
        printf("%s\t\t%d\t\t%.2f\n", inventory[i].name, inventory[i].quantity, inventory[i].price);
    }
}

// Main function
int main() {
    Product inventory[100];
    int size = 0;

    // Add products to inventory
    addProduct(inventory, size, "Apple", 50, 1.00);
    addProduct(inventory, size, "Banana", 30, 0.50);
    addProduct(inventory, size, "Orange", 20, 0.75);

    // Display inventory
    displayInventory(inventory, size);

    // Update quantity of product
    updateProduct(inventory, size, "Apple", 10);

    // Display updated inventory
    displayInventory(inventory, size);

    return 0;
}