//Gemma-7B DATASET v1.0 Category: Haunted House Simulator ; Style: satisfied
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_GHOSTS 5

typedef struct Ghost {
  char name[20];
  int room_num;
  int scare_factor;
} Ghost;

Ghost ghosts[MAX_GHOSTS] = {
  {"Mr. Jones", 1, 3},
  {"Mrs. Smith", 2, 2},
  {"The Phantom", 3, 5},
  {"The Witch", 4, 4},
  {"The Vampire", 5, 3}
};

int main() {
  srand(time(NULL));

  int num_ghosts = rand() % MAX_GHOSTS;
  int room_num = rand() % 5 + 1;

  for (int i = 0; i < num_ghosts; i++) {
    Ghost ghost = ghosts[i];

    if (ghost.room_num == room_num) {
      printf("You have encountered %s in room %d. Prepare for a scare!\n", ghost.name, room_num);

      switch (ghost.scare_factor) {
        case 1:
          printf("A gentle breeze whispers secrets in your ear.\n");
          break;
        case 2:
          printf("You hear footsteps behind you. Turn around slowly...\n");
          break;
        case 3:
          printf("A cold hand brushes against your skin. Goosebumps!\n");
          break;
        case 4:
          printf("A bloodcurdling scream echoes through the halls. Prepare for a heart attack!\n");
          break;
        case 5:
          printf("The hairs on your neck stand on end. You feel an evil presence lurking nearby.\n");
          break;
      }
    }
  }

  return 0;
}