//GEMINI-pro DATASET v1.0 Category: Sorting ; Style: Sherlock Holmes
// The Adventure of the Perplexing Permutations

#include <stdio.h>
#include <stdlib.h>

// Initialize the case file with a random set of suspects
int suspects[] = { 1, 2, 3, 4, 5, 6, 7, 8, 9 };
int numSuspects = sizeof(suspects) / sizeof(suspects[0]);

// Watson's preliminary investigation: display the unsorted suspects
void displayUnsortedSuspects() {
    printf("My dear Holmes, the suspects are initially as follows:\n");
    for (int i = 0; i < numSuspects; i++) {
        printf("%d ", suspects[i]);
    }
    printf("\n");
}

// Holmes' analytical method: implement a bubble sort
void bubbleSortSuspects() {
    printf("Let us commence with the bubble sort, Watson.\n");
    int swapped = 1;
    while (swapped) {
        swapped = 0;
        for (int i = 1; i < numSuspects; i++) {
            if (suspects[i - 1] > suspects[i]) {
                // Swap adjacent suspects
                int temp = suspects[i - 1];
                suspects[i - 1] = suspects[i];
                suspects[i] = temp;
                swapped = 1;
            }
        }
    }
    printf("The suspects are now sorted, my dear Watson.\n");
}

// Display the sorted suspects and announce the prime suspect
void displaySortedSuspects() {
    printf("Behold, the sorted suspects, and the prime suspect emerges:\n");
    for (int i = 0; i < numSuspects; i++) {
        printf("%d ", suspects[i]);
    }
    printf("\nThe prime suspect, the one who most likely committed the crime, is suspect number %d.\n", suspects[numSuspects - 1]);
}

int main() {
    // Stage the crime scene
    srand(time(NULL));
    for (int i = 0; i < numSuspects; i++) {
        suspects[i] += rand() % 10;
    }

    // Commence the investigation
    displayUnsortedSuspects();
    bubbleSortSuspects();
    displaySortedSuspects();

    return 0;
}