//LLAMA2-13B DATASET v1.0 Category: Arithmetic ; Style: thoughtful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_NAME_LEN 20
#define MAX_AGE 100

// Structure to store name and age
typedef struct {
    char name[MAX_NAME_LEN];
    int age;
} person;

// Function to print a person's details
void print_details(person p) {
    printf("Name: %s\nAge: %d\n", p.name, p.age);
}

// Function to calculate and print the average age of a list of people
void calculate_average_age(person *people, int num_people) {
    int sum_age = 0;
    for (int i = 0; i < num_people; i++) {
        sum_age += people[i].age;
    }
    int average_age = sum_age / num_people;
    printf("Average age: %d\n", average_age);
}

// Function to sort a list of people by age in ascending order
void sort_by_age(person *people, int num_people) {
    for (int i = 0; i < num_people - 1; i++) {
        for (int j = 0; j < num_people - i - 1; j++) {
            if (people[j].age < people[j + 1].age) {
                person temp = people[j];
                people[j] = people[j + 1];
                people[j + 1] = temp;
            }
        }
    }
}

int main() {
    person people[5] = {
        {"Alice", 25},
        {"Bob", 30},
        {"Charlie", 35},
        {"David", 20},
        {"Eve", 40}
    };

    int num_people = sizeof(people) / sizeof(people[0]);

    // Calculate and print the average age of the list
    calculate_average_age(people, num_people);

    // Sort the list by age in ascending order
    sort_by_age(people, num_people);

    // Print the sorted list of people
    for (int i = 0; i < num_people; i++) {
        print_details(people[i]);
    }

    return 0;
}