//Code Llama-13B DATASET v1.0 Category: Temperature monitor ; Style: paranoid
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define TEMP_THRESHOLD 100
#define TEMP_WARNING_THRESHOLD 90
#define TEMP_CRITICAL_THRESHOLD 80

int main(int argc, char *argv[]) {
  float temperature;
  int warning_flag = 0, critical_flag = 0;
  time_t current_time;

  // Read temperature from command line argument
  if (argc != 2) {
    printf("Usage: %s <temperature>\n", argv[0]);
    return 1;
  }
  temperature = atof(argv[1]);

  // Check if temperature is within safe limits
  if (temperature < TEMP_THRESHOLD) {
    printf("Temperature is within safe limits.\n");
    return 0;
  }

  // Check if temperature is within warning limits
  if (temperature >= TEMP_WARNING_THRESHOLD && temperature < TEMP_THRESHOLD) {
    warning_flag = 1;
  }

  // Check if temperature is within critical limits
  if (temperature >= TEMP_CRITICAL_THRESHOLD && temperature < TEMP_WARNING_THRESHOLD) {
    critical_flag = 1;
  }

  // Display temperature and warning/critical flags
  printf("Temperature: %f\n", temperature);
  if (warning_flag) {
    printf("Warning: Temperature is approaching the warning threshold.\n");
  }
  if (critical_flag) {
    printf("Critical: Temperature is above the critical threshold.\n");
  }

  // Get current time
  current_time = time(NULL);

  // Print time and temperature to file
  FILE *fp = fopen("temperature.log", "a");
  fprintf(fp, "%s, %f\n", ctime(&current_time), temperature);
  fclose(fp);

  return 0;
}