//Code Llama-13B DATASET v1.0 Category: Phone Book ; Style: automated
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PHONE_NUMBERS 100

typedef struct {
    char name[30];
    char phone_number[20];
} PhoneBookEntry;

void add_entry(PhoneBookEntry* phone_book, int* size, char* name, char* phone_number) {
    if (*size >= MAX_PHONE_NUMBERS) {
        printf("Phone book is full.\n");
        return;
    }

    strcpy(phone_book[*size].name, name);
    strcpy(phone_book[*size].phone_number, phone_number);
    (*size)++;
}

void print_entry(PhoneBookEntry* phone_book, int size, int index) {
    if (index >= size) {
        printf("Invalid index.\n");
        return;
    }

    printf("Name: %s\nPhone number: %s\n", phone_book[index].name, phone_book[index].phone_number);
}

void search_entry(PhoneBookEntry* phone_book, int size, char* name) {
    int index;
    for (index = 0; index < size; index++) {
        if (strcmp(phone_book[index].name, name) == 0) {
            print_entry(phone_book, size, index);
            return;
        }
    }

    printf("Entry not found.\n");
}

int main() {
    PhoneBookEntry phone_book[MAX_PHONE_NUMBERS];
    int size = 0;

    add_entry(phone_book, &size, "John", "123-456-7890");
    add_entry(phone_book, &size, "Jane", "234-567-8901");
    add_entry(phone_book, &size, "Bob", "345-678-9012");

    search_entry(phone_book, size, "Jane");

    return 0;
}