//GPT-4o-mini DATASET v1.0 Category: Building a POP3 Client ; Style: cheerful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>

#define POP3_PORT 110
#define BUFFER_SIZE 1024

void handle_error(const char *message) {
    perror(message);
    exit(EXIT_FAILURE);
}

void pop3_send_command(int sockfd, const char *command) {
    send(sockfd, command, strlen(command), 0);
}

void pop3_receive_response(int sockfd) {
    char buffer[BUFFER_SIZE];
    memset(buffer, 0, sizeof(buffer));
    
    // Read response from the server
    if (recv(sockfd, buffer, sizeof(buffer), 0) < 0) {
        handle_error("Failed to receive response");
    }
    
    // Print the response
    printf("%s", buffer);
}

void fetch_emails(int sockfd) {
    char command[BUFFER_SIZE];

    // Command to list messages
    pop3_send_command(sockfd, "LIST\r\n");
    pop3_receive_response(sockfd);

    // Retrieve the emails one by one
    pop3_send_command(sockfd, "RETR 1\r\n");
    pop3_receive_response(sockfd);
    
    // Continue fetching as needed
    pop3_send_command(sockfd, "RETR 2\r\n");
    pop3_receive_response(sockfd);

    // Once we're done, disconnect from the server - whew!
    pop3_send_command(sockfd, "QUIT\r\n");
    pop3_receive_response(sockfd);
}

int main() {
    // Start the celebration!
    printf("🎉 Welcome to Your POP3 Email Client! 🎉\n");

    const char *server_ip = "127.0.0.1"; // Change this to your SMTP server!
    int sockfd;
    struct sockaddr_in server_addr;

    // Create socket
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        handle_error("Could not create socket");
    }

    // Set up the server address structure
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(POP3_PORT);
    inet_pton(AF_INET, server_ip, &server_addr.sin_addr);

    // Connect to the server
    if (connect(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
        handle_error("Could not connect to server");
    }

    // Open the communication with a friendly hello
    pop3_receive_response(sockfd);

    // Log in (here you would normally send USER and PASS commands)
    // For demonstration, let's just assume we're logged in! Cheers!
    printf("🌟 Successfully connected to the mail server! 🌟\n");
    
    // Fetch and display emails
    fetch_emails(sockfd);

    // Close the socket and bring this party to an end
    close(sockfd);
    printf("🎈 Thank you for using the POP3 Email Client! 🎈\n");

    return 0;
}