//Falcon-180B DATASET v1.0 Category: Bitwise operations ; Style: irregular
#include <stdio.h>

// function to swap two numbers without using a temporary variable
void swap(int *a, int *b) {
    *a ^= *b;
    *b ^= *a;
    *a ^= *b;
}

// function to reverse a string using bitwise operators
void reverse_string(char *str) {
    int i = 0;
    int j = strlen(str) - 1;
    while (i < j) {
        char temp = str[i];
        str[i] = str[j];
        str[j] = temp;
        i++;
        j--;
    }
}

int main() {
    int num1 = 0b10101010;
    int num2 = 0b01010101;

    // set the 4th bit of num1 to 1
    num1 |= (1 << 3);

    // clear the 5th bit of num1
    num1 &= ~(1 << 4);

    // toggle the 6th bit of num1
    num1 ^= (1 << 5);

    // check if num1 is even
    if (num1 & 1 == 0) {
        printf("num1 is even\n");
    }

    // swap num1 and num2 without using a temporary variable
    swap(&num1, &num2);

    // reverse a string using bitwise operators
    char str1[] = "hello";
    reverse_string(str1);
    printf("%s\n", str1);

    return 0;
}