//Falcon-180B DATASET v1.0 Category: Weather simulation ; Style: random
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_CITIES 10
#define MAX_WEATHER_TYPES 5
#define MAX_WEATHER_INTENSITY 5

typedef struct {
    char name[20];
    int x;
    int y;
} City;

typedef struct {
    char name[20];
    int intensity;
} WeatherType;

City cities[MAX_CITIES];
WeatherType weatherTypes[MAX_WEATHER_TYPES];

void init() {
    // Initialize random seed
    srand(time(NULL));

    // Initialize cities
    for (int i = 0; i < MAX_CITIES; i++) {
        cities[i].name[0] = '\0';
        cities[i].x = rand() % 100;
        cities[i].y = rand() % 100;
    }

    // Initialize weather types
    for (int i = 0; i < MAX_WEATHER_TYPES; i++) {
        weatherTypes[i].name[0] = '\0';
        weatherTypes[i].intensity = rand() % MAX_WEATHER_INTENSITY + 1;
    }
}

void printCity(City city) {
    printf("City: %s (%d, %d)\n", city.name, city.x, city.y);
}

void printWeatherType(WeatherType weatherType) {
    printf("Weather Type: %s (Intensity: %d)\n", weatherType.name, weatherType.intensity);
}

int main() {
    init();

    // Simulate weather for each city
    for (int i = 0; i < MAX_CITIES; i++) {
        City city = cities[i];
        WeatherType weatherType = weatherTypes[rand() % MAX_WEATHER_TYPES];

        printf("Weather in %s:\n", city.name);
        printWeatherType(weatherType);
    }

    return 0;
}