//Falcon-180B DATASET v1.0 Category: Database simulation ; Style: genious
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of records that can be stored in the database
#define MAX_RECORDS 100

// Define the structure of each record in the database
typedef struct {
    int id;
    char name[50];
    int age;
} Record;

// Declare the global array to store the records
Record database[MAX_RECORDS];

// Declare the variable to keep track of the number of records in the database
int num_records = 0;

// Function to add a new record to the database
void add_record(int id, char* name, int age) {
    if (num_records >= MAX_RECORDS) {
        printf("Error: Database is full.\n");
        return;
    }

    database[num_records].id = id;
    strcpy(database[num_records].name, name);
    database[num_records].age = age;

    num_records++;
}

// Function to search for a record by ID
int search_by_id(int id) {
    for (int i = 0; i < num_records; i++) {
        if (database[i].id == id) {
            return i;
        }
    }

    return -1;
}

// Function to search for a record by name
int search_by_name(char* name) {
    for (int i = 0; i < num_records; i++) {
        if (strcmp(database[i].name, name) == 0) {
            return i;
        }
    }

    return -1;
}

// Function to print all records in the database
void print_records() {
    printf("ID\tName\tAge\n");
    for (int i = 0; i < num_records; i++) {
        printf("%d\t%s\t%d\n", database[i].id, database[i].name, database[i].age);
    }
}

// Function to delete a record from the database
void delete_record(int id) {
    int index = search_by_id(id);
    if (index == -1) {
        printf("Error: Record not found.\n");
        return;
    }

    for (int i = index; i < num_records - 1; i++) {
        database[i] = database[i + 1];
    }

    num_records--;
}

// Main function to simulate the database operations
int main() {
    // Initialize the database with some records
    add_record(1, "John Doe", 30);
    add_record(2, "Jane Smith", 25);
    add_record(3, "Bob Johnson", 40);

    // Print all records in the database
    print_records();

    // Search for a record by ID
    int index = search_by_id(2);
    if (index!= -1) {
        printf("Found record with ID %d\n", database[index].id);
    } else {
        printf("Record not found.\n");
    }

    // Search for a record by name
    index = search_by_name("Jane Smith");
    if (index!= -1) {
        printf("Found record with name %s\n", database[index].name);
    } else {
        printf("Record not found.\n");
    }

    // Delete a record from the database
    delete_record(2);

    // Print all records in the database again
    print_records();

    return 0;
}