//Code Llama-13B DATASET v1.0 Category: File handling ; Style: invasive
/*
 * File handling example program in an invasive style
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>

int main(void) {
  // Open the file in write-only mode
  int fd = open("file.txt", O_WRONLY | O_CREAT, 0666);
  if (fd == -1) {
    perror("open");
    exit(EXIT_FAILURE);
  }

  // Write to the file
  char buf[] = "Hello, world!";
  if (write(fd, buf, strlen(buf)) == -1) {
    perror("write");
    exit(EXIT_FAILURE);
  }

  // Close the file
  if (close(fd) == -1) {
    perror("close");
    exit(EXIT_FAILURE);
  }

  // Open the file in read-only mode
  fd = open("file.txt", O_RDONLY);
  if (fd == -1) {
    perror("open");
    exit(EXIT_FAILURE);
  }

  // Read from the file
  char read_buf[100];
  if (read(fd, read_buf, 100) == -1) {
    perror("read");
    exit(EXIT_FAILURE);
  }

  // Print the contents of the file
  printf("Read from file: %s\n", read_buf);

  // Close the file
  if (close(fd) == -1) {
    perror("close");
    exit(EXIT_FAILURE);
  }

  return 0;
}