//Gemma-7B DATASET v1.0 Category: Planet Gravity Simulation ; Style: secure
#include <stdio.h>
#include <math.h>

#define G 6.674e-11

typedef struct Particle {
    double mass;
    double x;
    double y;
    double z;
    double ax;
    double ay;
    double az;
} Particle;

void calculateForces(Particle *particles, int numParticles) {
    for (int i = 0; i < numParticles; i++) {
        particles[i].ax = 0.0;
        particles[i].ay = 0.0;
        particles[i].az = 0.0;

        for (int j = 0; j < numParticles; j++) {
            if (i != j) {
                double dx = particles[j].x - particles[i].x;
                double dy = particles[j].y - particles[i].y;
                double dz = particles[j].z - particles[i].z;

                double distance = sqrt(dx * dx + dy * dy + dz * dz);

                double force = G * particles[i].mass * particles[j].mass / distance * distance;

                particles[i].ax += force * dx / particles[i].mass;
                particles[i].ay += force * dy / particles[i].mass;
                particles[i].az += force * dz / particles[i].mass;
            }
        }
    }
}

int main() {
    Particle particles[2];
    particles[0].mass = 10.0;
    particles[0].x = 0.0;
    particles[0].y = 0.0;
    particles[0].z = 0.0;
    particles[0].ax = 0.0;
    particles[0].ay = 0.0;
    particles[0].az = 0.0;

    particles[1].mass = 20.0;
    particles[1].x = 2.0;
    particles[1].y = 0.0;
    particles[1].z = 0.0;
    particles[1].ax = 0.0;
    particles[1].ay = 0.0;
    particles[1].az = 0.0;

    calculateForces(particles, 2);

    printf("Particle 1 acceleration: (%f, %f, %f)\n", particles[0].ax, particles[0].ay, particles[0].az);
    printf("Particle 2 acceleration: (%f, %f, %f)\n", particles[1].ax, particles[1].ay, particles[1].az);

    return 0;
}