//GPT-4o-mini DATASET v1.0 Category: Modern Encryption ; Style: peaceful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <openssl/aes.h>
#include <openssl/rand.h>

void handleErrors() {
    fprintf(stderr, "An error occurred!\n");
    exit(EXIT_FAILURE);
}

void generate_key(unsigned char *key) {
    if (!RAND_bytes(key, AES_BLOCK_SIZE)) {
        handleErrors();
    }
}

void encrypt(unsigned char *input, unsigned char *output, unsigned char *key) {
    AES_KEY enc_key;
    if (AES_set_encrypt_key(key, 128, &enc_key) < 0) {
        handleErrors();
    }

    AES_encrypt(input, output, &enc_key);
}

void decrypt(unsigned char *input, unsigned char *output, unsigned char *key) {
    AES_KEY dec_key;
    if (AES_set_decrypt_key(key, 128, &dec_key) < 0) {
        handleErrors();
    }

    AES_decrypt(input, output, &dec_key);
}

int main() {
    unsigned char key[AES_BLOCK_SIZE];
    generate_key(key);

    unsigned char input[AES_BLOCK_SIZE] = "SomePeacefulText";
    unsigned char encrypted[AES_BLOCK_SIZE];
    unsigned char decrypted[AES_BLOCK_SIZE];

    // Print original message
    printf("Original Message: %s\n", input);

    // Encrypt the message
    encrypt(input, encrypted, key);
    printf("Encrypted Message: ");
    for (int i = 0; i < AES_BLOCK_SIZE; i++) {
        printf("%02x", encrypted[i]);
    }
    printf("\n");

    // Decrypt the message
    decrypt(encrypted, decrypted, key);
    decrypted[AES_BLOCK_SIZE - 1] = '\0'; // Add null terminator
    printf("Decrypted Message: %s\n", decrypted);

    // Display key for user knowledge (don't do in production!)
    printf("Encryption Key (for reference): ");
    for (int i = 0; i < AES_BLOCK_SIZE; i++) {
        printf("%02x", key[i]);
    }
    printf("\n");

    return 0;
}