//GEMINI-pro DATASET v1.0 Category: URL Sanitizer ; Style: futuristic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define CYBER_MAX_URL_SIZE 2048

// Paranoid URL Sanitizer 3000
char *cyber_sanitize_url(char *input_url) {
    char *sanitized_url = malloc(CYBER_MAX_URL_SIZE);
    if (sanitized_url == NULL) {
        return NULL;
    }

    char *curr_char = input_url;
    char *sanitized_char = sanitized_url;

    while (*curr_char != '\0') {
        if (*curr_char == ' ') {
            *sanitized_char = '+';
        } else if (*curr_char == '<') {
            *sanitized_char = '%';
            *(sanitized_char + 1) = '3';
            *(sanitized_char + 2) = 'C';
            sanitized_char += 2;
        } else if (*curr_char == '>') {
            *sanitized_char = '%';
            *(sanitized_char + 1) = '3';
            *(sanitized_char + 2) = 'E';
            sanitized_char += 2;
        } else if (*curr_char == '%') {
            *sanitized_char = '%';
            *(sanitized_char + 1) = '2';
            *(sanitized_char + 2) = '5';
            sanitized_char += 2;
        } else {
            *sanitized_char = *curr_char;
        }

        curr_char++;
        sanitized_char++;
    }

    *sanitized_char = '\0';

    return sanitized_url;
}

int main() {
    char *input_url = "https://example.com/index.html?q=Hello%20World%";
    char *sanitized_url = cyber_sanitize_url(input_url);

    printf("Sanitized URL: %s\n", sanitized_url);

    free(sanitized_url);
    return 0;
}