//Falcon-180B DATASET v1.0 Category: Network Packet Monitoring ; Style: brave
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pcap.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <netinet/udp.h>

#define MAX_PKT_SIZE 65535
#define SNAPLEN 65535
#define TRUE 1
#define FALSE 0

void die(char *s) {
    perror(s);
    exit(1);
}

void process_packet(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    struct ip *ip;
    struct tcphdr *tcp;
    struct udphdr *udp;
    char src_ip[INET_ADDRSTRLEN];
    char dst_ip[INET_ADDRSTRLEN];
    char src_port[6];
    char dst_port[6];

    ip = (struct ip *) packet;
    inet_ntop(AF_INET, &ip->ip_src, src_ip, INET_ADDRSTRLEN);
    inet_ntop(AF_INET, &ip->ip_dst, dst_ip, INET_ADDRSTRLEN);

    if (ip->ip_p == IPPROTO_TCP) {
        tcp = (struct tcphdr *) (packet + ip->ip_hl * 4);
        sprintf(src_port, "%d", ntohs(tcp->source));
        sprintf(dst_port, "%d", ntohs(tcp->dest));
    } else if (ip->ip_p == IPPROTO_UDP) {
        udp = (struct udphdr *) (packet + ip->ip_hl * 4);
        sprintf(src_port, "%d", ntohs(udp->source));
        sprintf(dst_port, "%d", ntohs(udp->dest));
    }

    printf("Src IP: %s\tDst IP: %s\tSrc Port: %s\tDst Port: %s\n", src_ip, dst_ip, src_port, dst_port);
}

int main(int argc, char **argv) {
    char *dev;
    char errbuf[PCAP_ERRBUF_SIZE];
    pcap_t *handle;
    struct bpf_program filter;
    char filter_exp[] = "tcp or udp";

    if (argc!= 2) {
        printf("Usage: %s <interface>\n", argv[0]);
        exit(1);
    }

    dev = argv[1];

    handle = pcap_open_live(dev, SNAPLEN, TRUE, 0, errbuf);
    if (handle == NULL) {
        die(errbuf);
    }

    pcap_compile(handle, &filter, filter_exp, 0, PCAP_NETMASK_UNKNOWN);
    pcap_setfilter(handle, &filter);

    pcap_loop(handle, -1, process_packet, NULL);

    pcap_freecode(&filter);
    pcap_close(handle);

    return 0;
}