//Code Llama-13B DATASET v1.0 Category: TCP/IP Programming ; Style: excited
/*
* Unique C TCP/IP Programming example program in an excited style
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>

int main() {
    // Create a socket
    int sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("socket() failed");
        return 1;
    }

    // Bind the socket to a port
    struct sockaddr_in addr;
    memset(&addr, 0, sizeof(addr));
    addr.sin_family = AF_INET;
    addr.sin_port = htons(8080);
    addr.sin_addr.s_addr = INADDR_ANY;
    if (bind(sock, (struct sockaddr*)&addr, sizeof(addr)) < 0) {
        perror("bind() failed");
        return 1;
    }

    // Listen for incoming connections
    if (listen(sock, 3) < 0) {
        perror("listen() failed");
        return 1;
    }

    // Accept an incoming connection
    struct sockaddr_in client_addr;
    socklen_t client_len = sizeof(client_addr);
    int client_sock = accept(sock, (struct sockaddr*)&client_addr, &client_len);
    if (client_sock < 0) {
        perror("accept() failed");
        return 1;
    }

    // Read data from the client
    char buf[1024];
    memset(buf, 0, sizeof(buf));
    int bytes_read = recv(client_sock, buf, sizeof(buf), 0);
    if (bytes_read < 0) {
        perror("recv() failed");
        return 1;
    }

    // Print the received data
    printf("Received %d bytes: %s\n", bytes_read, buf);

    // Write data to the client
    char response[] = "Hello, client!";
    int bytes_written = send(client_sock, response, sizeof(response), 0);
    if (bytes_written < 0) {
        perror("send() failed");
        return 1;
    }

    // Close the socket
    close(client_sock);

    return 0;
}