//Falcon-180B DATASET v1.0 Category: Interprocess communication ; Style: minimalist
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>

#define TRUE   1
#define FALSE  0
#define MAX    100

// structure for messages
struct msgbuf {
    long mtype;
    char mtext[MAX];
};

int main() {
    int msqid;
    key_t key;
    char *message = "Hello, world!";

    // get a unique key
    key = ftok(".", 'a');

    // create a message queue
    msqid = msgget(key, IPC_CREAT | 0666);
    if (msqid == -1) {
        printf("Error creating message queue.\n");
        exit(1);
    }

    // send a message
    struct msgbuf msg;
    strcpy(msg.mtext, message);
    msg.mtype = 1;
    if (msgsnd(msqid, &msg, strlen(message), 0) == -1) {
        printf("Error sending message.\n");
        exit(1);
    }

    // receive a message
    struct msgbuf received_msg;
    int received_size;
    if (msgrcv(msqid, &received_msg, MAX, 0, 0) == -1) {
        printf("Error receiving message.\n");
        exit(1);
    }

    printf("Received message: %s\n", received_msg.mtext);

    return 0;
}