//GEMINI-pro DATASET v1.0 Category: Product Inventory System ; Style: grateful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

#define MAX_PRODUCTS 100

typedef struct {
    char name[50];
    char description[200];
    int quantity;
    float price;
} product;

product inventory[MAX_PRODUCTS];
int num_products = 0;

void add_product(product p) {
    if (num_products >= MAX_PRODUCTS) {
        printf("Error: Cannot add more products. Inventory is full.\n");
        return;
    }

    inventory[num_products] = p;
    num_products++;
}

void remove_product(char *name) {
    int i;

    for (i = 0; i < num_products; i++) {
        if (strcmp(inventory[i].name, name) == 0) {
            inventory[i] = inventory[num_products - 1];
            num_products--;
            return;
        }
    }

    printf("Error: Product not found.\n");
}

void update_product(char *name, product p) {
    int i;

    for (i = 0; i < num_products; i++) {
        if (strcmp(inventory[i].name, name) == 0) {
            inventory[i] = p;
            return;
        }
    }

    printf("Error: Product not found.\n");
}

void print_inventory() {
    int i;

    printf("Inventory:\n");
    for (i = 0; i < num_products; i++) {
        printf("%s - %s - %d - %.2f\n", inventory[i].name, inventory[i].description, inventory[i].quantity, inventory[i].price);
    }
}

int main() {
    product p1 = {"Apple", "A delicious red fruit", 10, 1.99};
    product p2 = {"Orange", "A juicy citrus fruit", 15, 2.49};
    product p3 = {"Banana", "A sweet yellow fruit", 20, 1.49};
    product p4 = {"Grape", "A small round fruit", 25, 2.99};

    add_product(p1);
    add_product(p2);
    add_product(p3);
    add_product(p4);

    print_inventory();

    remove_product("Apple");

    print_inventory();

    product p5 = {"Mango", "A tropical fruit", 10, 3.49};

    update_product("Orange", p5);

    print_inventory();

    return 0;
}