//Falcon-180B DATASET v1.0 Category: Music Library Management System ; Style: surrealist
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_MUSIC_FILES 100
#define MAX_SONG_NAME_LENGTH 50
#define MAX_ARTIST_NAME_LENGTH 50
#define MAX_ALBUM_NAME_LENGTH 50

typedef struct {
  char songName[MAX_SONG_NAME_LENGTH];
  char artistName[MAX_ARTIST_NAME_LENGTH];
  char albumName[MAX_ALBUM_NAME_LENGTH];
  int duration;
  int fileSize;
} MusicFile;

MusicFile musicFiles[MAX_MUSIC_FILES];
int numMusicFiles = 0;

void addMusicFile() {
  numMusicFiles++;
}

void removeMusicFile() {
  numMusicFiles--;
}

void displayMusicFiles() {
  printf("Music Library:\n");
  for (int i = 0; i < numMusicFiles; i++) {
    printf("File %d:\n", i + 1);
    printf("Song Name: %s\n", musicFiles[i].songName);
    printf("Artist Name: %s\n", musicFiles[i].artistName);
    printf("Album Name: %s\n", musicFiles[i].albumName);
    printf("Duration: %d seconds\n", musicFiles[i].duration);
    printf("File Size: %d bytes\n\n", musicFiles[i].fileSize);
  }
}

int main() {
  addMusicFile();
  addMusicFile();
  addMusicFile();
  displayMusicFiles();
  removeMusicFile();
  removeMusicFile();
  displayMusicFiles();
  return 0;
}