//GEMINI-pro DATASET v1.0 Category: Checkers Game ; Style: Ken Thompson
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define BOARD_SIZE 8

typedef struct {
  int x, y;
} Position;

typedef struct {
  char type;
  int color;
  Position position;
} Piece;

typedef struct {
  Piece board[BOARD_SIZE][BOARD_SIZE];
} Board;

void printBoard(Board *board) {
  for (int i = 0; i < BOARD_SIZE; i++) {
    for (int j = 0; j < BOARD_SIZE; j++) {
      Piece piece = board->board[i][j];
      if (piece.type == ' ') {
        printf("  ");
      } else {
        printf("%c%c", piece.type, piece.color ? 'W' : 'B');
      }
    }
    printf("\n");
  }
}

int main() {
  Board board;
  memset(&board, 0, sizeof(Board));

  for (int i = 0; i < BOARD_SIZE; i++) {
    for (int j = 0; j < BOARD_SIZE; j++) {
      if ((i + j) % 2 == 0) {
        Piece piece;
        piece.type = 'p';
        piece.color = i < 3;
        piece.position.x = i;
        piece.position.y = j;
        board.board[i][j] = piece;
      }
    }
  }

  printBoard(&board);

  return 0;
}