//Gemma-7B DATASET v1.0 Category: Remote control Vehicle Simulation ; Style: modular
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_SPEED 10
#define MAX_TURN 90

typedef struct Vehicle
{
    int x;
    int y;
    int direction;
    int speed;
} Vehicle;

Vehicle vehicle;

void initializeVehicle()
{
    vehicle.x = 0;
    vehicle.y = 0;
    vehicle.direction = 0;
    vehicle.speed = 0;
}

void moveVehicle(int direction, int speed)
{
    switch (direction)
    {
        case 0:
            vehicle.x++;
            break;
        case 1:
            vehicle.y++;
            break;
        case 2:
            vehicle.x--;
            break;
        case 3:
            vehicle.y--;
            break;
    }

    vehicle.speed = speed;
}

void turnVehicle(int angle)
{
    vehicle.direction += angle;
    if (vehicle.direction > MAX_TURN)
    {
        vehicle.direction = MAX_TURN;
    }
    else if (vehicle.direction < 0)
    {
        vehicle.direction = 0;
    }
}

int main()
{
    initializeVehicle();

    // Simulate remote control vehicle movement
    moveVehicle(0, 5);
    moveVehicle(1, 3);
    turnVehicle(45);
    moveVehicle(2, 2);
    moveVehicle(3, 4);

    // Print vehicle position and direction
    printf("X: %d, Y: %d, Direction: %d\n", vehicle.x, vehicle.y, vehicle.direction);

    return 0;
}