//GEMINI-pro DATASET v1.0 Category: Cryptography Implementation ; Style: real-life
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <openssl/evp.h>

// Encrypt data using AES-256-CBC with a given key and IV
int encrypt(unsigned char *plaintext, int plaintext_len, unsigned char *key,
            unsigned char *iv, unsigned char *ciphertext) {
    EVP_CIPHER_CTX *ctx;

    // Create and initialize the context
    if (!(ctx = EVP_CIPHER_CTX_new())) {
        return -1;
    }

    // Initialize the context for encryption
    if (EVP_EncryptInit_ex(ctx, EVP_aes_256_cbc(), NULL, key, iv) != 1) {
        EVP_CIPHER_CTX_free(ctx);
        return -1;
    }

    // Encrypt the data
    if (EVP_EncryptUpdate(ctx, ciphertext, &plaintext_len, plaintext, plaintext_len) != 1) {
        EVP_CIPHER_CTX_free(ctx);
        return -1;
    }

    // Finalize the encryption
    if (EVP_EncryptFinal_ex(ctx, ciphertext + plaintext_len, &plaintext_len) != 1) {
        EVP_CIPHER_CTX_free(ctx);
        return -1;
    }

    // Clean up
    EVP_CIPHER_CTX_free(ctx);
    return plaintext_len;
}

// Decrypt data using AES-256-CBC with a given key and IV
int decrypt(unsigned char *ciphertext, int ciphertext_len, unsigned char *key,
            unsigned char *iv, unsigned char *plaintext) {
    EVP_CIPHER_CTX *ctx;

    // Create and initialize the context
    if (!(ctx = EVP_CIPHER_CTX_new())) {
        return -1;
    }

    // Initialize the context for decryption
    if (EVP_DecryptInit_ex(ctx, EVP_aes_256_cbc(), NULL, key, iv) != 1) {
        EVP_CIPHER_CTX_free(ctx);
        return -1;
    }

    // Decrypt the data
    if (EVP_DecryptUpdate(ctx, plaintext, &ciphertext_len, ciphertext, ciphertext_len) != 1) {
        EVP_CIPHER_CTX_free(ctx);
        return -1;
    }

    // Finalize the decryption
    if (EVP_DecryptFinal_ex(ctx, plaintext + ciphertext_len, &ciphertext_len) != 1) {
        EVP_CIPHER_CTX_free(ctx);
        return -1;
    }

    // Clean up
    EVP_CIPHER_CTX_free(ctx);
    return ciphertext_len;
}

int main() {
    // Define the plaintext and key
    unsigned char plaintext[] = "Hello, world!";
    unsigned char key[] = "0123456789ABCDEF0123456789ABCDEF";
    unsigned char iv[] = "00000000000000000000000000000000";

    // Encrypt the plaintext
    int ciphertext_len = encrypt(plaintext, strlen(plaintext) + 1, key, iv, NULL);
    if (ciphertext_len < 0) {
        fprintf(stderr, "Error encrypting plaintext\n");
        return -1;
    }
    unsigned char ciphertext[ciphertext_len];
    ciphertext_len = encrypt(plaintext, strlen(plaintext) + 1, key, iv, ciphertext);
    if (ciphertext_len < 0) {
        fprintf(stderr, "Error encrypting plaintext\n");
        return -1;
    }

    // Decrypt the ciphertext
    int plaintext_len = decrypt(ciphertext, ciphertext_len, key, iv, NULL);
    if (plaintext_len < 0) {
        fprintf(stderr, "Error decrypting ciphertext\n");
        return -1;
    }
    unsigned char plaintext_decrypted[plaintext_len];
    plaintext_len = decrypt(ciphertext, ciphertext_len, key, iv, plaintext_decrypted);
    if (plaintext_len < 0) {
        fprintf(stderr, "Error decrypting ciphertext\n");
        return -1;
    }

    // Print the plaintext and decrypted plaintext
    printf("Plaintext: %s\n", plaintext);
    printf("Decrypted plaintext: %s\n", plaintext_decrypted);

    return 0;
}