//GEMINI-pro DATASET v1.0 Category: Bitwise operations ; Style: surprised
#include <stdio.h>
#include <stdlib.h>

int main() {
  // Surprise! A bitwise operations extravaganza!

  int a = 0b10101010; // Start with a 10-bit binary number
  int b = 0b01010101; // Another 10-bit binary number

  // Bitwise AND: &
  int c = a & b; // Perform a bitwise AND operation on a and b
  printf("Bitwise AND: %d (%010b)\n", c, c); // Print the result

  // Bitwise OR: |
  c = a | b; // Perform a bitwise OR operation on a and b
  printf("Bitwise OR: %d (%010b)\n", c, c); // Print the result

  // Bitwise XOR: ^
  c = a ^ b; // Perform a bitwise XOR operation on a and b
  printf("Bitwise XOR: %d (%010b)\n", c, c); // Print the result

  // Bitwise NOT: ~
  c = ~a; // Perform a bitwise NOT operation on a
  printf("Bitwise NOT: %d (%010b)\n", c, c); // Print the result

  // Bitwise Left Shift: <<
  c = a << 2; // Perform a bitwise left shift on a by 2 bits
  printf("Bitwise Left Shift: %d (%010b)\n", c, c); // Print the result

  // Bitwise Right Shift: >>
  c = a >> 2; // Perform a bitwise right shift on a by 2 bits
  printf("Bitwise Right Shift: %d (%010b)\n", c, c); // Print the result

  // Surprise! Here's a fun one: Bitwise NAND
  c = ~(a & b); // Perform a bitwise NAND operation on a and b
  printf("Bitwise NAND: %d (%010b)\n", c, c); // Print the result

  // And here's another surprise: Bitwise NOR
  c = ~(a | b); // Perform a bitwise NOR operation on a and b
  printf("Bitwise NOR: %d (%010b)\n", c, c); // Print the result

  // But wait, there's more! Bitwise XNOR
  c = ~(a ^ b); // Perform a bitwise XNOR operation on a and b
  printf("Bitwise XNOR: %d (%010b)\n", c, c); // Print the result

  // Phew! That was a lot of bitwise operations.
  // I hope you enjoyed this surprising and educational demonstration!

  return 0;
}