//GEMINI-pro DATASET v1.0 Category: Threading Library Implementation ; Style: relaxed
#include <stdio.h>
#include <pthread.h>
#include <unistd.h>

// Declare a global variable that will be shared by all threads
int shared_var = 0;

// Create a mutex to protect the shared variable
pthread_mutex_t shared_var_mutex = PTHREAD_MUTEX_INITIALIZER;

// Define a thread function that will increment the shared variable
void *increment_thread(void *arg)
{
    // Acquire the mutex to protect the shared variable
    pthread_mutex_lock(&shared_var_mutex);

    // Increment the shared variable
    shared_var++;

    // Release the mutex
    pthread_mutex_unlock(&shared_var_mutex);

    // Return NULL to indicate that the thread has finished executing
    return NULL;
}

// Define a thread function that will decrement the shared variable
void *decrement_thread(void *arg)
{
    // Acquire the mutex to protect the shared variable
    pthread_mutex_lock(&shared_var_mutex);

    // Decrement the shared variable
    shared_var--;

    // Release the mutex
    pthread_mutex_unlock(&shared_var_mutex);

    // Return NULL to indicate that the thread has finished executing
    return NULL;
}

int main()
{
    // Create two threads, one to increment the shared variable and one to decrement it
    pthread_t increment_thread_id, decrement_thread_id;
    pthread_create(&increment_thread_id, NULL, increment_thread, NULL);
    pthread_create(&decrement_thread_id, NULL, decrement_thread, NULL);

    // Wait for the threads to finish executing
    pthread_join(increment_thread_id, NULL);
    pthread_join(decrement_thread_id, NULL);

    // Print the final value of the shared variable
    printf("Final value of shared variable: %d\n", shared_var);

    return 0;
}