//GEMINI-pro DATASET v1.0 Category: Sudoku solver ; Style: complex
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

#define N 9

// Function to print the Sudoku grid
void print_grid(int grid[N][N]) {
  for (int i = 0; i < N; i++) {
    for (int j = 0; j < N; j++) {
      printf("%d ", grid[i][j]);
    }
    printf("\n");
  }
}

// Function to check if the grid is valid
bool is_valid(int grid[N][N]) {
  // Check each row for duplicate values
  for (int i = 0; i < N; i++) {
    int row[N] = {0};
    for (int j = 0; j < N; j++) {
      if (grid[i][j] != 0 && row[grid[i][j] - 1]) {
        return false;
      }
      row[grid[i][j] - 1] = true;
    }
  }

  // Check each column for duplicate values
  for (int j = 0; j < N; j++) {
    int col[N] = {0};
    for (int i = 0; i < N; i++) {
      if (grid[i][j] != 0 && col[grid[i][j] - 1]) {
        return false;
      }
      col[grid[i][j] - 1] = true;
    }
  }

  // Check each 3x3 subgrid for duplicate values
  for (int i = 0; i < N; i += 3) {
    for (int j = 0; j < N; j += 3) {
      int subgrid[N] = {0};
      for (int ii = i; ii < i + 3; ii++) {
        for (int jj = j; jj < j + 3; jj++) {
          if (grid[ii][jj] != 0 && subgrid[grid[ii][jj] - 1]) {
            return false;
          }
          subgrid[grid[ii][jj] - 1] = true;
        }
      }
    }
  }

  return true;
}

// Function to solve the Sudoku grid
bool solve_sudoku(int grid[N][N]) {
  for (int i = 0; i < N; i++) {
    for (int j = 0; j < N; j++) {
      if (grid[i][j] == 0) {
        for (int k = 0; k < N; k++) {
          grid[i][j] = k + 1;
          if (is_valid(grid)) {
            if (solve_sudoku(grid)) {
              return true;
            }
          }
          grid[i][j] = 0;
        }
        return false;
      }
    }
  }
  return true;
}

int main() {
  // Initialize the Sudoku grid
  int grid[N][N] = {
    {5, 3, 0, 0, 7, 0, 0, 0, 0},
    {6, 0, 0, 1, 9, 5, 0, 0, 0},
    {0, 9, 8, 0, 0, 0, 0, 6, 0},
    {8, 0, 0, 0, 6, 0, 0, 0, 3},
    {4, 0, 0, 8, 0, 3, 0, 0, 1},
    {7, 0, 0, 0, 2, 0, 0, 0, 6},
    {0, 6, 0, 0, 0, 0, 2, 8, 0},
    {0, 0, 0, 4, 1, 9, 0, 0, 5},
    {0, 0, 0, 0, 8, 0, 0, 7, 9},
  };

  // Solve the Sudoku grid
  if (solve_sudoku(grid)) {
    printf("Solved Sudoku grid:\n");
    print_grid(grid);
  } else {
    printf("No solution exists for the given Sudoku grid.\n");
  }

  return 0;
}