//MISTRAL-7B DATASET v1.0 Category: Building a HTTP Client ; Style: single-threaded
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <curl/curl.h>

#define BUF_SIZE 4096

struct write_callback {
    FILE *fp;
    size_t size;
    size_t nmemb;
};

static size_t write_data(void *ptr, size_t size, size_t nmemb, void *stream) {
    size_t written = fwrite(ptr, size, nmemb, ((struct write_callback *)stream)->fp);
    ((struct write_callback *)stream)->size += written;
    return size * nmemb;
}

int main(int argc, char *argv[]) {
    CURL *curl;
    CURLcode res;
    struct write_callback callback;

    if (argc != 3) {
        fprintf(stderr, "Usage: %s <URL> <output_file>\n", argv[0]);
        return 1;
    }

    curl = curl_easy_init();
    if (curl) {
        callback.fp = fopen(argv[2], "wb");
        if (!callback.fp) {
            fprintf(stderr, "Failed to open output file.\n");
            curl_easy_cleanup(curl);
            return 1;
        }

        curl_easy_setopt(curl, CURLOPT_URL, argv[1]);
        curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, write_data);
        curl_easy_setopt(curl, CURLOPT_WRITEDATA, &callback);

        res = curl_easy_perform(curl);
        if (res != CURLE_OK) {
            fprintf(stderr, "curl_easy_perform() failed: %s\n", curl_easy_strerror(res));
        }

        curl_easy_cleanup(curl);
        fclose(callback.fp);
    }

    return 0;
}