//GEMINI-pro DATASET v1.0 Category: Expense Tracker ; Style: surprised
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// What?! A C Expense Tracker? You sure you want this?

// Expense struct
typedef struct Expense {
    char *category;    // Oh my, what did you spend it on?
    double amount;     // Whoa, that's a lot of dough!
    char *description; // Oh really, care to tell us why?
} Expense;

// Array of expenses
Expense expenses[100]; // Hold your horses, we can track up to 100 expenses!

// Expense counter
int expense_count = 0; // Starting with a clean slate

// Add an expense
void add_expense(char *category, double amount, char *description) {
    // Wait a minute, you're adding an expense?
    expenses[expense_count].category = strdup(category); // Oh, so that's where it went!
    expenses[expense_count].amount = amount; // Holy cow, that's a hefty amount!
    expenses[expense_count].description = strdup(description); // Hmm, sounds like a reasonable reason.
    expense_count++; // Hey, one more expense in the books!
}

// Print all expenses
void print_expenses() {
    // Oho, let's see where all your money went!
    for (int i = 0; i < expense_count; i++) {
        printf("Category: %s\n", expenses[i].category); // Aha, so that's where it went!
        printf("Amount: %.2f\n", expenses[i].amount); // Not bad, not bad at all!
        printf("Description: %s\n\n", expenses[i].description); // Well, that explains it!
    }
}

// Free all expenses
void free_expenses() {
    // Whoops, time to clean up!
    for (int i = 0; i < expense_count; i++) {
        free(expenses[i].category); // Bye-bye, category!
        free(expenses[i].description); // So long, description!
    }
}

// Main function
int main() {
    // Welcome to the most amazing C Expense Tracker ever!
    printf("Welcome to the C Expense Tracker!\n");
    
    // Add some expenses
    add_expense("Food", 10.00, "Lunch at the office");
    add_expense("Transportation", 20.00, "Gas for the car");
    add_expense("Entertainment", 30.00, "Movie tickets");
    
    // Print all expenses
    print_expenses();
    
    // Free all expenses
    free_expenses();
    
    return 0;
}