//GEMINI-pro DATASET v1.0 Category: Robot movement control ; Style: curious
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define ROBOT_MOVES 4
#define ROBOT_STEPS 8

typedef enum {
  NORTH,
  EAST,
  SOUTH,
  WEST
} direction_t;

typedef struct {
  direction_t direction;
  int steps;
} move_t;

typedef struct {
  int x;
  int y;
} position_t;

void print_robot(position_t position) {
  printf("The robot is at (%d, %d)\n", position.x, position.y);
}

void move_robot(position_t *position, move_t *move) {
  switch (move->direction) {
  case NORTH:
    position->y += move->steps;
    break;
  case EAST:
    position->x += move->steps;
    break;
  case SOUTH:
    position->y -= move->steps;
    break;
  case WEST:
    position->x -= move->steps;
    break;
  }
}

void generate_random_moves(move_t *moves) {
  int i;
  for (i = 0; i < ROBOT_MOVES; i++) {
    moves[i].direction = rand() % ROBOT_MOVES;
    moves[i].steps = rand() % ROBOT_STEPS;
  }
}

int main() {
  srand(time(NULL));

  position_t position = {0, 0};
  move_t moves[ROBOT_MOVES];

  print_robot(position);

  generate_random_moves(moves);

  int i;
  for (i = 0; i < ROBOT_MOVES; i++) {
    move_robot(&position, &moves[i]);
    print_robot(position);
  }

  return 0;
}