//Gemma-7B DATASET v1.0 Category: Haunted House Simulator ; Style: excited
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

#define MAX_GHOULS 5

typedef struct Ghost {
  char name[20];
  int room;
  int health;
  int speed;
} Ghost;

Ghost ghosts[MAX_GHOULS];

void initializeGhosts() {
  for (int i = 0; i < MAX_GHOULS; i++) {
    ghosts[i].name[0] = '\0';
    ghosts[i].room = 0;
    ghosts[i].health = 100;
    ghosts[i].speed = 0;
  }
}

void scare(Ghost *ghost) {
  printf("BOO! %s has appeared!\n", ghost->name);
  ghost->health = 0;
}

int main() {
  initializeGhosts();

  srand(time(NULL));

  for (int i = 0; i < MAX_GHOULS; i++) {
    ghosts[i].name[0] = 'A' + i;
    ghosts[i].room = rand() % 5;
    ghosts[i].speed = rand() % 3;
  }

  for (int i = 0; i < MAX_GHOULS; i++) {
    printf("Ghost %s is in room %d, moving at speed %d.\n", ghosts[i].name, ghosts[i].room, ghosts[i].speed);
  }

  for (int i = 0; i < MAX_GHOULS; i++) {
    if (ghosts[i].health == 0) {
      printf("Ghost %s has been defeated!\n", ghosts[i].name);
    }
  }

  return 0;
}