//MISTRAL-7B DATASET v1.0 Category: Checksum Calculator ; Style: minimalist
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define BLOCK_SIZE 64
#define CHECKSUM_SIZE 4

typedef struct {
    unsigned char data[BLOCK_SIZE];
    unsigned short checksum;
} Block;

void calculate_checksum(Block *block) {
    unsigned short sum = 0;

    for (int i = 0; i < BLOCK_SIZE; ++i) {
        sum += block->data[i];
    }

    block->checksum = sum;
    sum = 0;

    for (int i = 0; i < BLOCK_SIZE; ++i) {
        sum += block->data[i];
        sum += (sum >> 8);
    }

    block->checksum += (sum & 0xFFFF);
    sum = 0;
}

void print_block(const Block *block) {
    printf("Data: ");
    for (int i = 0; i < BLOCK_SIZE; ++i) {
        printf("%02X ", block->data[i]);
    }
    printf("\nChecksum: %04X\n", block->checksum);
}

int main() {
    const char data[] = "Checksum Calculator Example Program";
    Block blocks[1];

    int length = sizeof(data) / BLOCK_SIZE;
    int remaining_data = sizeof(data) % BLOCK_SIZE;

    memset(blocks, 0, sizeof(blocks));

    int index = 0;
    for (int i = 0; i < length; ++i) {
        memcpy(blocks[index++].data, data + i * BLOCK_SIZE, BLOCK_SIZE);
        calculate_checksum(&blocks[index - 1]);
    }

    if (remaining_data > 0) {
        memcpy(blocks[index].data, data + length * BLOCK_SIZE, remaining_data);
        calculate_checksum(&blocks[index]);
        ++index;
    }

    for (int i = 0; i < index; ++i) {
        print_block(&blocks[i]);
    }

    return 0;
}