//Falcon-180B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: grateful
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_PROCESSES 10
#define MAX_PRIORITY 10
#define MAX_CPU_BURST 5

typedef struct {
    int id;
    int priority;
    int cpu_burst;
    int waiting_time;
    int turnaround_time;
} Process;

void generate_processes(Process* processes) {
    for (int i = 0; i < NUM_PROCESSES; i++) {
        processes[i].id = i + 1;
        processes[i].priority = rand() % MAX_PRIORITY + 1;
        processes[i].cpu_burst = rand() % MAX_CPU_BURST + 1;
    }
}

void print_processes(Process* processes) {
    printf("Process ID\tPriority\tCPU Burst\n");
    for (int i = 0; i < NUM_PROCESSES; i++) {
        printf("%d\t\t%d\t\t%d\n", processes[i].id, processes[i].priority, processes[i].cpu_burst);
    }
}

int compare_priority(const void* a, const void* b) {
    Process* p1 = (Process*)a;
    Process* p2 = (Process*)b;
    return (p1->priority > p2->priority) - (p1->priority < p2->priority);
}

int main() {
    srand(time(NULL));

    Process processes[NUM_PROCESSES];
    generate_processes(processes);
    print_processes(processes);

    qsort(processes, NUM_PROCESSES, sizeof(Process), compare_priority);

    printf("\nProcesses sorted by priority:\n");
    print_processes(processes);

    return 0;
}