//GEMINI-pro DATASET v1.0 Category: Building a POP3 Client ; Style: peaceful
#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <string.h>

#define SERVER_PORT 110

int main() {
  // Create a socket for the client.
  int sockfd = socket(AF_INET, SOCK_STREAM, 0);
  if (sockfd < 0) {
    perror("socket");
    return EXIT_FAILURE;
  }

  // Set up the server address.
  struct sockaddr_in server_addr;
  memset(&server_addr, 0, sizeof(server_addr));
  server_addr.sin_family = AF_INET;
  server_addr.sin_port = htons(SERVER_PORT);
  server_addr.sin_addr.s_addr = inet_addr("127.0.0.1");

  // Connect to the server.
  if (connect(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
    perror("connect");
    return EXIT_FAILURE;
  }

  // Send the USER command.
  char *user_cmd = "USER username\r\n";
  if (send(sockfd, user_cmd, strlen(user_cmd), 0) < 0) {
    perror("send");
    return EXIT_FAILURE;
  }

  // Receive the server's response.
  char server_resp[1024];
  if (recv(sockfd, server_resp, sizeof(server_resp), 0) < 0) {
    perror("recv");
    return EXIT_FAILURE;
  }

  // Print the server's response.
  printf("Server response: %s", server_resp);

  // Send the PASS command.
  char *pass_cmd = "PASS password\r\n";
  if (send(sockfd, pass_cmd, strlen(pass_cmd), 0) < 0) {
    perror("send");
    return EXIT_FAILURE;
  }

  // Receive the server's response.
  if (recv(sockfd, server_resp, sizeof(server_resp), 0) < 0) {
    perror("recv");
    return EXIT_FAILURE;
  }

  // Print the server's response.
  printf("Server response: %s", server_resp);

  // Send the LIST command.
  char *list_cmd = "LIST\r\n";
  if (send(sockfd, list_cmd, strlen(list_cmd), 0) < 0) {
    perror("send");
    return EXIT_FAILURE;
  }

  // Receive the server's response.
  if (recv(sockfd, server_resp, sizeof(server_resp), 0) < 0) {
    perror("recv");
    return EXIT_FAILURE;
  }

  // Print the server's response.
  printf("Server response: %s", server_resp);

  // Send the RETR command.
  char *retr_cmd = "RETR 1\r\n";
  if (send(sockfd, retr_cmd, strlen(retr_cmd), 0) < 0) {
    perror("send");
    return EXIT_FAILURE;
  }

  // Receive the server's response.
  if (recv(sockfd, server_resp, sizeof(server_resp), 0) < 0) {
    perror("recv");
    return EXIT_FAILURE;
  }

  // Print the server's response.
  printf("Server response: %s", server_resp);

  // Send the QUIT command.
  char *quit_cmd = "QUIT\r\n";
  if (send(sockfd, quit_cmd, strlen(quit_cmd), 0) < 0) {
    perror("send");
    return EXIT_FAILURE;
  }

  // Receive the server's response.
  if (recv(sockfd, server_resp, sizeof(server_resp), 0) < 0) {
    perror("recv");
    return EXIT_FAILURE;
  }

  // Print the server's response.
  printf("Server response: %s", server_resp);

  // Close the socket.
  close(sockfd);

  return EXIT_SUCCESS;
}