//GEMINI-pro DATASET v1.0 Category: Electronic Voting System ; Style: energetic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_CANDIDATES 10
#define MAX_VOTERS 100

typedef struct {
    char name[50];
    int votes;
} Candidate;

typedef struct {
    char name[50];
    int candidate_id;
} Voter;

Candidate candidates[MAX_CANDIDATES];
Voter voters[MAX_VOTERS];
int num_candidates = 0;
int num_voters = 0;

void add_candidate(char *name) {
    if (num_candidates >= MAX_CANDIDATES) {
        printf("Error: Maximum number of candidates reached!\n");
        return;
    }
    strcpy(candidates[num_candidates].name, name);
    candidates[num_candidates].votes = 0;
    num_candidates++;
}

void add_voter(char *name, int candidate_id) {
    if (num_voters >= MAX_VOTERS) {
        printf("Error: Maximum number of voters reached!\n");
        return;
    }
    strcpy(voters[num_voters].name, name);
    voters[num_voters].candidate_id = candidate_id;
    num_voters++;
}

void print_candidates() {
    printf("Candidates:\n");
    for (int i = 0; i < num_candidates; i++) {
        printf("%d. %s\n", i+1, candidates[i].name);
    }
}

void print_voters() {
    printf("Voters:\n");
    for (int i = 0; i < num_voters; i++) {
        printf("%d. %s voted for candidate %d\n", i+1, voters[i].name, voters[i].candidate_id);
    }
}

void count_votes() {
    for (int i = 0; i < num_voters; i++) {
        candidates[voters[i].candidate_id - 1].votes++;
    }
}

void print_results() {
    printf("Results:\n");
    for (int i = 0; i < num_candidates; i++) {
        printf("%d. %s: %d votes\n", i+1, candidates[i].name, candidates[i].votes);
    }
}

int main() {
    // Add candidates
    add_candidate("John Doe");
    add_candidate("Jane Doe");
    add_candidate("Bob Smith");
    add_candidate("Alice Johnson");
    add_candidate("Tom Jones");

    // Add voters
    add_voter("Alice", 1);
    add_voter("Bob", 2);
    add_voter("Charlie", 3);
    add_voter("Dave", 4);
    add_voter("Eve", 5);

    // Print candidates
    print_candidates();

    // Print voters
    print_voters();

    // Count votes
    count_votes();

    // Print results
    print_results();

    return 0;
}