//Falcon-180B DATASET v1.0 Category: Socket programming ; Style: scientific
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define BUFFER_SIZE 1024

int main(int argc, char *argv[]) {
    int sockfd, newsockfd, portno, clilen, ret;
    struct sockaddr_in serv_addr, cli_addr;
    char buffer[BUFFER_SIZE];

    // Create socket
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd == 0) {
        perror("Error creating socket");
        exit(1);
    }

    // Set up server address
    memset(&serv_addr, 0, sizeof(serv_addr));
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_addr.s_addr = INADDR_ANY;
    serv_addr.sin_port = htons(8080);

    // Bind socket to address
    ret = bind(sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr));
    if (ret < 0) {
        perror("Error binding socket");
        exit(1);
    }

    // Listen for incoming connections
    ret = listen(sockfd, 5);
    if (ret < 0) {
        perror("Error listening on socket");
        exit(1);
    }

    printf("Server is listening on port 8080\n");

    // Accept incoming connections
    clilen = sizeof(cli_addr);
    newsockfd = accept(sockfd, (struct sockaddr *)&cli_addr, &clilen);
    if (newsockfd < 0) {
        perror("Error accepting connection");
        exit(1);
    }

    printf("Connection accepted\n");

    // Receive data from client
    ret = recv(newsockfd, buffer, BUFFER_SIZE, 0);
    if (ret < 0) {
        perror("Error receiving data");
        exit(1);
    }

    printf("Received data: %s\n", buffer);

    // Send data to client
    strcpy(buffer, "Data received");
    ret = send(newsockfd, buffer, strlen(buffer), 0);
    if (ret < 0) {
        perror("Error sending data");
        exit(1);
    }

    printf("Data sent to client\n");

    // Close connections
    close(newsockfd);
    close(sockfd);

    return 0;
}