//Code Llama-13B DATASET v1.0 Category: Smart home light control ; Style: interoperable
// interoperable_smart_light_control.c

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define NUM_LIGHTS 5
#define LIGHT_ON 1
#define LIGHT_OFF 0

typedef struct {
  int id;
  int state;
} light_t;

void lights_init(light_t* lights, int num_lights) {
  for (int i = 0; i < num_lights; i++) {
    lights[i].id = i;
    lights[i].state = LIGHT_OFF;
  }
}

void lights_on(light_t* lights, int num_lights) {
  for (int i = 0; i < num_lights; i++) {
    if (lights[i].state == LIGHT_OFF) {
      lights[i].state = LIGHT_ON;
    }
  }
}

void lights_off(light_t* lights, int num_lights) {
  for (int i = 0; i < num_lights; i++) {
    if (lights[i].state == LIGHT_ON) {
      lights[i].state = LIGHT_OFF;
    }
  }
}

void lights_toggle(light_t* lights, int num_lights) {
  for (int i = 0; i < num_lights; i++) {
    if (lights[i].state == LIGHT_ON) {
      lights[i].state = LIGHT_OFF;
    } else {
      lights[i].state = LIGHT_ON;
    }
  }
}

void lights_print(light_t* lights, int num_lights) {
  for (int i = 0; i < num_lights; i++) {
    printf("%d: %s\n", lights[i].id, lights[i].state ? "on" : "off");
  }
}

int main() {
  light_t lights[NUM_LIGHTS];
  lights_init(lights, NUM_LIGHTS);
  lights_on(lights, NUM_LIGHTS);
  lights_off(lights, NUM_LIGHTS);
  lights_toggle(lights, NUM_LIGHTS);
  lights_print(lights, NUM_LIGHTS);
  return 0;
}