//GPT-4o-mini DATASET v1.0 Category: Maze Route Finder ; Style: ultraprecise
#include <stdio.h>
#include <stdlib.h>

#define N 5  // Size of the maze

// Function prototypes
void printMaze(int maze[N][N], int path[N][N]);
int isSafe(int maze[N][N], int x, int y);
int solveMazeUtil(int maze[N][N], int x, int y, int path[N][N]);
void solveMaze(int maze[N][N]);

// Function to print the solution path
void printMaze(int maze[N][N], int path[N][N]) {
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            if (path[i][j] == 1) {
                printf("  *  ");  // Path taken
            } else if (maze[i][j] == 1) {
                printf("  #  ");  // Wall
            } else {
                printf("     ");  // Empty space
            }
        }
        printf("\n");
    }
}

// Function to check if (x, y) is a valid cell
int isSafe(int maze[N][N], int x, int y) {
    return (x >= 0 && x < N && y >= 0 && y < N && maze[x][y] == 0);
}

// Recursive utility to solve the maze
int solveMazeUtil(int maze[N][N], int x, int y, int path[N][N]) {
    // If (x, y) is the goal, return true
    if (x == N - 1 && y == N - 1) {
        path[x][y] = 1;
        return 1;
    }

    // Check if the current position is safe
    if (isSafe(maze, x, y)) {
        // Mark x, y as part of the solution path
        path[x][y] = 1;

        // Move forward in x direction
        if (solveMazeUtil(maze, x + 1, y, path)) {
            return 1;
        }

        // If moving in x direction doesn't lead to a solution,
        // move down in y direction
        if (solveMazeUtil(maze, x, y + 1, path)) {
            return 1;
        }

        // If none of the movements work out, backtrack
        path[x][y] = 0;
        return 0;
    }

    return 0;
}

// Function to solve the maze
void solveMaze(int maze[N][N]) {
    int path[N][N] = { {0} };  // Initialize solution path

    if (solveMazeUtil(maze, 0, 0, path) == 0) {
        printf("No solution exists\n");
    } else {
        printMaze(maze, path);
    }
}

// Main function
int main() {
    // Example maze represented as a 2D array
    int maze[N][N] = { {0, 1, 0, 0, 0},
                       {0, 1, 0, 1, 0},
                       {0, 0, 0, 1, 0},
                       {1, 1, 0, 0, 0},
                       {0, 1, 1, 1, 0} };

    printf("Input Maze:\n");
    printMaze(maze, (int[N][N]){0});  // Print input maze without path

    printf("\nFinding solution...\n\n");
    solveMaze(maze);
    
    return 0;
}