//MISTRAL-7B DATASET v1.0 Category: Robot movement control ; Style: Ken Thompson
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/i2c-dev.h>

#define I2C_ADDR 0x20
#define REG_MOTOR_X 0x00
#define REG_MOTOR_Y 0x01
#define REG_MOTOR_Z 0x02
#define REG_LED 0x0f

int fd;
char buf[2];

void write_reg(int reg, int value) {
    buf[0] = (reg << 1) | 0x01;
    buf[1] = value;
    write(fd, buf, 2);
}

void move_robot(int x, int y, int z) {
    write_reg(REG_MOTOR_X, x);
    write_reg(REG_MOTOR_Y, y);
    write_reg(REG_MOTOR_Z, z);
}

void turn_on_led(int num) {
    write_reg(REG_LED, 1 << num);
}

void turn_off_led(int num) {
    write_reg(REG_LED, ~(1 << num) & 0x1f);
}

int main(int argc, char **argv) {
    int x, y, z, i;

    if ((fd = open("/dev/i2c-1", O_RDWR)) < 0) {
        perror("Could not open I2C device");
        return 1;
    }

    if (ioctl(fd, I2C_SLAVE, I2C_ADDR) < 0) {
        perror("Could not access I2C slave");
        return 1;
    }

    x = 50;
    y = 50;
    z = 50;

    move_robot(x, y, z);

    for (i = 0; i < 10; i++) {
        turn_on_led(i);
        sleep(1);
        turn_off_led(i);
    }

    close(fd);

    return 0;
}