//Falcon-180B DATASET v1.0 Category: Network Ping Test ; Style: grateful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <errno.h>

#define MAX 100

// Function to print error message and exit
void error(char *message) {
    perror(message);
    exit(1);
}

// Function to send a ping packet
int send_ping(int sockfd, struct sockaddr *dest_addr) {
    char buffer[MAX];
    int nbytes;

    nbytes = sendto(sockfd, "PING", strlen("PING"), 0, dest_addr, sizeof(dest_addr));

    if (nbytes <= 0) {
        error("Sendto error");
    }

    return nbytes;
}

// Function to receive a ping response
int receive_pong(int sockfd, struct sockaddr *src_addr, char *buffer, int maxlen) {
    int nbytes;

    nbytes = recvfrom(sockfd, buffer, maxlen, 0, src_addr, NULL);

    if (nbytes <= 0) {
        error("Recvfrom error");
    }

    return nbytes;
}

// Function to check if a ping response is valid
int is_valid_pong(char *buffer) {
    if (strcmp(buffer, "PONG") == 0) {
        return 1;
    } else {
        return 0;
    }
}

int main(int argc, char *argv[]) {
    int sockfd;
    struct sockaddr_in dest_addr, src_addr;
    char buffer[MAX];
    int nbytes;
    int valid_pong = 0;

    // Create a socket
    if ((sockfd = socket(AF_INET, SOCK_DGRAM, 0)) == -1) {
        error("Socket error");
    }

    // Set up the destination address
    dest_addr.sin_family = AF_INET;
    dest_addr.sin_port = htons(12345);

    // Set up the source address
    src_addr.sin_family = AF_INET;
    src_addr.sin_port = htons(12345);

    // Send a ping packet
    nbytes = send_ping(sockfd, (struct sockaddr *)&dest_addr);

    // Receive a ping response
    nbytes = receive_pong(sockfd, (struct sockaddr *)&src_addr, buffer, MAX);

    // Check if the response is valid
    if (is_valid_pong(buffer)) {
        valid_pong = 1;
    }

    // Close the socket
    close(sockfd);

    if (valid_pong) {
        printf("Pong received!\n");
    } else {
        printf("No pong received.\n");
    }

    return 0;
}