//GEMINI-pro DATASET v1.0 Category: Banking Record System ; Style: Alan Turing
#include <stdio.h>
#include <stdlib.h>

// Define the structure of a bank account
typedef struct {
  int account_number;
  char name[50];
  double balance;
} bank_account;

// Create an array of bank accounts
bank_account accounts[100];

// Initialize the bank accounts
void initialize_accounts() {
  for (int i = 0; i < 100; i++) {
    accounts[i].account_number = i;
    sprintf(accounts[i].name, "Customer %d", i + 1);
    accounts[i].balance = 0.0;
  }
}

// Print the bank accounts
void print_accounts() {
  for (int i = 0; i < 100; i++) {
    printf("Account %d: %s, Balance: %f\n", accounts[i].account_number, accounts[i].name, accounts[i].balance);
  }
}

// Deposit money into an account
void deposit_money(int account_number, double amount) {
  accounts[account_number].balance += amount;
}

// Withdraw money from an account
void withdraw_money(int account_number, double amount) {
  if (accounts[account_number].balance >= amount) {
    accounts[account_number].balance -= amount;
  } else {
    printf("Insufficient funds\n");
  }
}

// Transfer money from one account to another
void transfer_money(int from_account_number, int to_account_number, double amount) {
  if (accounts[from_account_number].balance >= amount) {
    accounts[from_account_number].balance -= amount;
    accounts[to_account_number].balance += amount;
  } else {
    printf("Insufficient funds\n");
  }
}

// Main function
int main() {
  // Initialize the bank accounts
  initialize_accounts();

  // Print the bank accounts
  print_accounts();

  // Deposit money into account 1
  deposit_money(0, 100.0);

  // Withdraw money from account 2
  withdraw_money(1, 50.0);

  // Transfer money from account 1 to account 3
  transfer_money(0, 2, 25.0);

  // Print the bank accounts
  print_accounts();

  return 0;
}